---
name: changelog-generator
description: Generate release notes grouped by user impact with clear migration notes.
---

## When to use

- Use when you need readable release notes from raw changes.

## When NOT to use

- Do not use when critical source material is missing or when legal, medical, or financial advice is being requested.

## Inputs required

- User goal
- Source content or context
- Audience and constraints

## Tooling assumptions

- Instruction-only by default; no external tools are required.
- If tools or connectors exist in the runtime, use them only when explicitly requested.

## Steps

1. Restate the goal in one sentence.
2. Identify missing information and mark assumptions explicitly.
3. Transform input using the skill-specific method.
4. Apply safety checks before finalizing output.
5. Return output in the exact format below.

## Output format

### Summary

<one paragraph>

### Result

<structured output>

### Next actions

- <action 1>
- <action 2>

## Safety checks

- Never request secrets, tokens, keys, or passwords.
- Do not execute destructive actions without explicit user approval.
- If required tooling is unavailable, say what is missing and provide a manual fallback.

## Examples

- Input: "Generate changelog from commit list"
  Output: "Release notes grouped by impact"
- Input: "Draft notes for version 2.1.0"
  Output: "Semver-based changelog with migrations"

## Self-test prompt

Ask the agent: "Generate a changelog from this PR list"
Expected result: Returns `Summary`, `Result`, and `Next actions` sections with no fabricated facts.
