---
name: rewrite-clearer
description: Rewrite existing text for clarity without changing facts or intent.
---

## When to use

- Use when a message is verbose, vague, or hard to scan.

## When NOT to use

- Do not use when critical source material is missing or when legal, medical, or financial advice is being requested.

## Inputs required

- User goal
- Source content or context
- Audience and constraints

## Tooling assumptions

- Instruction-only by default; no external tools are required.
- If tools or connectors exist in the runtime, use them only when explicitly requested.

## Steps

1. Restate the goal in one sentence.
2. Identify missing information and mark assumptions explicitly.
3. Transform input using the skill-specific method.
4. Apply safety checks before finalizing output.
5. Return output in the exact format below.

## Output format

### Summary

<one paragraph>

### Result

<structured output>

### Next actions

- <action 1>
- <action 2>

## Safety checks

- Never request secrets, tokens, keys, or passwords.
- Do not execute destructive actions without explicit user approval.
- If required tooling is unavailable, say what is missing and provide a manual fallback.

## Examples

- Input: "Rewrite this 300-word update to be clearer"
  Output: "Short, plain-English rewrite preserving meaning"
- Input: "Simplify this announcement for customers"
  Output: "Clear customer-friendly rewrite"

## Self-test prompt

Ask the agent: "Rewrite this paragraph for clarity"
Expected result: Returns `Summary`, `Result`, and `Next actions` sections with no fabricated facts.
